Attribute VB_Name = "modMain"
Option Explicit

Public Sub Main()
   Dim strPath          As String

   ' Normalize Path
   strPath = App.Path
   If Right$(strPath, 1) <> "/" Then
      strPath = strPath & "/"
   End If

   CreateAuthorsXML strPath & "Authors.xml"
End Sub

Public Sub CreateAuthorsXML(strXMLFile As String)
   Dim rsAuthors      As ADODB.Recordset

   Set rsAuthors = New ADODB.Recordset

   ' Open recordset with a few columns
   ' Limit to just a few records with WHERE clause
   rsAuthors.Source = "SELECT au_id, au_fname, au_lname " _
                    & "FROM Authors WHERE au_id < 5"

   ' In the following, you need to change "srvr" to the
   ' name of your SQL Server
   rsAuthors.ActiveConnection = "Provider=sqloledb;" & _
      "Data Source=srvr;Initial Catalog=pubs;User Id=sa;Password=; "

   ' All set to open recordset...
   rsAuthors.Open

   ' An error occurs if the target already exists,
   ' so delete target if there
   If FileExists(strXMLFile) Then Kill strXMLFile

   ' Requires ADO 2.1 or later
   rsAuthors.Save strXMLFile, adPersistXML

   ' Clean Up
   rsAuthors.Close
   Set rsAuthors = Nothing
End Sub

Function FileExists(ByVal strFileName As String) As Boolean
    FileExists = CBool(Len(Dir$(strFileName, vbNormal _
                    + vbHidden _
                    + vbSystem _
                    + vbVolume _
                    + vbDirectory)))
End Function
